//
//  GSMetricValue.h
//  GlyphsCore
//
//  Created by Georg Seifert on 05.12.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSContainerProtocol.h>
#import <GlyphsCore/GSContentProtocol.h>
#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
#import <GlyphsCore/GSIdentifiableParameter.h>
#endif
#import <Foundation/Foundation.h>

@class GSMetric;
NS_ASSUME_NONNULL_BEGIN
/**
 @note `GSIdentifiableParameter` compliance: Returns the `parameterIdentifier` of its `metric` property, if applicable.
 */
#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
@interface GSMetricValue : NSObject <NSCopying, GSIdentifiableParameter, GSContentProtocol>
#else
@interface GSMetricValue : NSObject <NSCopying>
#endif
{
	CGFloat _position;
	CGFloat _overshoot;
}

- (instancetype)initWithDict:(NSDictionary *)dict format:(GSFormatVersion)formatVersion;
- (instancetype)initWithPosition:(CGFloat)position;
- (instancetype)initWithPosition:(CGFloat)position overshoot:(CGFloat)overshoot;

/** Returns the content of the object to store it in pList.

 This is used to store the data in the .glyphs file.
 @param format the version of the dict
 */
- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

#ifndef LIBCORE
- (NSDictionary *)clipboardValueFormat:(GSFormatVersion)format;
#endif

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE *)file format:(GSFormatVersion)formatVersion error:(NSError **)error;
#endif

@property (weak, nonatomic, nullable) GSContainer *parent;

@property (nonatomic, weak) GSMetric *metric;

@property (nonatomic, assign) CGFloat position;
@property (nonatomic, assign) CGFloat overshoot;

// will return self.metric.title
@property (nonatomic, readonly) NSString *title;

@end
NS_ASSUME_NONNULL_END
